<?php
/**
 * File 2016_10_10_121700_update_comment_table.php
 *
 * @package    Database\Migrations\v2_1_0\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Selfservice;

use App\Modules\Selfservice\Models\Article;
use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateCommentTable
 *
 * @package    Database\Migrations\v2_1_0\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateCommentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add the type_id column.
        Schema::table('comment', function (Blueprint $table) {
            $table->integer('type_id')->unsigned()->after('article_id');
        });

        // Get all articles.
        $articles = Article::get([ 'id', 'type_id' ]);

        // Fill in type_id value for all comments.
        foreach ($articles as $article) {
            DB::table('comment')
                ->where('article_id', $article->id)
                ->update([ 'type_id' => $article->type_id ]);
        }

        // Add the foreign key index for type_id.
        Schema::table('comment', function (Blueprint $table) {
            $table->foreign('type_id')->references('id')->on('article_type')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop the type_id column.
        Schema::table('comment', function (Blueprint $table) {
            $table->dropForeign([ 'type_id' ]);
            $table->dropColumn('type_id');
        });
    }
}
