<?php
/**
 * File 2016_10_11_138293_update_article_table.php
 *
 * @package    Database\Migrations\v2_1_0\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Selfservice;

use App\Modules\Selfservice\Models\Article;
use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateArticleTable
 *
 * @package    Database\Migrations\v2_1_0\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateArticleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create article_type_membership records for all articles.
        $articles = Article::all([ 'id', 'type_id' ])->map(function ($article, $key) {
            return [
                'article_id' => $article->id,
                'type_id'    => $article->type_id,
                'views'      => (int) $article->views // This can be null, so cast to int.
            ];
        });

        // Insert into the database.
        $chunks = array_chunk($articles->toArray(), 200);
        foreach ($chunks as $chunk) {
            DB::table('article_type_membership')->insert($chunk);
        }

        // Drop the type_id column.
        Schema::table('article', function (Blueprint $table) {
            $table->dropForeign([ 'type_id' ]);
            $table->dropColumn([ 'type_id', 'views' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Add type_id column back.
        Schema::table('article', function (Blueprint $table) {
            $table->integer('type_id')->unsigned()->after('id');
            $table->integer('views')->nullable()->default(0)->after('text');
        });

        // Copy the records back over.
        $records = DB::table('article_type_membership')->get();
        foreach ($records as $record) {
            DB::table('article')->where('id', $record->article_id)->update([
                'type_id' => $record->type_id,
                'views' => $record->views
            ]);
        }

        // Add foreign key back
        Schema::table('article', function (Blueprint $table) {
            $table->foreign('type_id')->references('id')->on('article_type')->onDelete('cascade');
        });
    }
}
