<?php
/**
 * File 2016_09_12_134600_update_canned_response_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Ticket;

use DB;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateCannedResponseTable
 *
 * @package    Database\Migrations\v2_1_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateCannedResponseTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        // Convert to utf8mb4_unicode_ci
        DB::unprepared("ALTER TABLE `canned_response` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        // Convert to utf8_unicode_ci
        DB::unprepared("ALTER TABLE `canned_response` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
