<?php
/**
 * File 2016_09_12_1706002_update_ticket_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Ticket;

use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketTable
 *
 * @package    Database\Migrations\v2_1_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class AlterTicketTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        Schema::table('ticket', function (Blueprint $table) {
            $table->string('number', 191)->change();
        });

        // Convert to utf8mb4_unicode_ci
        DB::unprepared("ALTER TABLE `ticket` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        // Convert to utf8_unicode_ci
        DB::unprepared("ALTER TABLE `ticket` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");

        Schema::table('ticket', function (Blueprint $table) {
            $table->string('number', 255)->change();
        });

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
