<?php
/**
 * File 2016_09_28_115700_update_ticket_viewed_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketViewedTable
 *
 * @package    Database\Migrations\v2_1_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateTicketViewedTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_viewed', function (Blueprint $table) {
            $table->dropColumn('id');
            $table->tinyInteger('read_latest_message')->default(1)->after('user_type');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_viewed', function (Blueprint $table) {
            $table->increments('id')->unsigned()->first();
            $table->dropColumn('read_latest_message');
        });
    }
}
