<?php
/**
 * File 2016_10_21_189111_update_ticket_table.php
 *
 * @package    Database\Migrations\v2_1_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Ticket;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketTable
 *
 * @package    Database\Migrations\v2_1_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateTicketTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket', function (Blueprint $table) {
            $table->dropForeign([ 'company_id' ]);
            $table->dropForeign([ 'sla_plan_id' ]);

            $table->renameColumn('company_id', 'brand_id');

            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');
            $table->foreign('sla_plan_id')->references('id')->on('sla_plan')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket', function (Blueprint $table) {
            $table->dropForeign([ 'brand_id' ]);
            $table->dropForeign([ 'sla_plan_id' ]);

            $table->renameColumn('brand_id', 'company_id');

            $table->foreign('company_id')->references('id')->on('brand')->onDelete('cascade');
            $table->foreign('sla_plan_id')->references('id')->on('sla_plan')->onDelete('cascade');
        });
    }
}
