<?php
/**
 * File 2016_10_23_198390_update_department_email_table.php
 *
 * @package    Database\Migrations\v2_1_0\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Ticket;

use App\Modules\Core\Models\Brand;
use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateDepartmentEmailTable
 *
 * @package    Database\Migrations\v2_1_0\Selfservice
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateDepartmentEmailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('department_email', function (Blueprint $table) {
            $table->integer('brand_id')->unsigned()->after('department_id');
        });

        // Only if we have existing types (not on fresh install)
        if (DB::table('department_email')->count()) {
            DB::table('department_email')->update([ 'brand_id' => Brand::first()->id ]);
        }

        Schema::table('department_email', function (Blueprint $table) {
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');

            // DEV-1089.
            $table->string('password', 510)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('department_email', function (Blueprint $table) {
            $table->dropForeign([ 'brand_id' ]);
            $table->dropColumn('brand_id');

            $table->string('password', 255)->change();
        });
    }
}
