<?php
/**
 * File 2016_12_19_182393_update_department_table.php
 *
 * @package    Database\Migrations\v2_1_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\Ticket;

use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Arr;
use Schema;

/**
 * Class UpdateDepartmentTable
 *
 * @package    Database\Migrations\v2_1_0\Ticket
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateDepartmentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Disable ticket_autoclose template for all departments that have notify_ticket_autoclose.
        $departments = DB::table('department')->where('notify_ticket_autoclose', 0)->get();
        foreach ($departments as $department) {
            if (isset($department->email_templates)) {
                $templates = json_decode($department->email_templates, true);
                $templates['ticket_autoclose'] = -1;

                DB::table('department')
                    ->where('id', $department->id)
                    ->update([ 'email_templates' => json_encode($templates) ]);
            }
        }

        // Disable ticket_operatorclose template for all departments that have notify_ticket_closed.
        $departments = DB::table('department')->where('notify_ticket_closed', 0)->get();
        foreach ($departments as $department) {
            if (isset($department->email_templates)) {
                $templates = json_decode($department->email_templates, true);
                $templates['ticket_operatorclose'] = -1;

                DB::table('department')
                    ->where('id', $department->id)
                    ->update([ 'email_templates' => json_encode($templates) ]);
            }
        }

        // Drop columns.
        Schema::table('department', function (Blueprint $table) {
            $table->dropColumn('notify_ticket_autoclose');
            $table->dropColumn('notify_ticket_closed');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('department', function (Blueprint $table) {
            $table->tinyInteger('notify_ticket_autoclose')->after('default_assignedto');
            $table->tinyInteger('notify_ticket_closed')->after('notify_ticket_autoclose');
        });

        // Set columns to 0, if template is disabled.
        $departments = DB::table('department')->get();
        foreach ($departments as $department) {
            if (isset($department->email_templates)) {
                $templates = json_decode($department->email_templates, true);

                if (Arr::get($templates, 'ticket_autoclose') === -1) {
                    $department->notify_ticket_autoclose = 0;
                }

                if (Arr::get($templates, 'ticket_operatorclose') === -1) {
                    $department->notify_ticket_closed = 0;
                }

                DB::table('department')
                    ->where('id', $department->id)
                    ->update([
                        'notify_ticket_autoclose' => $department->notify_ticket_autoclose,
                        'notify_ticket_closed'    => $department->notify_ticket_closed
                    ]);
            }
        }
    }
}
