<?php
/**
 * File 2016_09_12_170600_update_user_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\User;

use Database\Migrations\v2_1_0\Core\UpdateLanguageTable;
use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class AlterUserTable
 *
 * @package    Database\Migrations\v2_1_0\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class AlterUserTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        Schema::table('user', function (Blueprint $table) {
            // Check whether MySQL 5.6 FULLTEXT index exists, otherwise it will throw an error..
            $exists = (int) DB::select(
                "SELECT COUNT(*) AS index_exists 
                  FROM information_schema.statistics 
                  WHERE `TABLE_SCHEMA` = DATABASE() and `table_name` = 'user' AND `index_name` = 'firstname'"
            )[0]->index_exists;

            if ($exists > 0) {
                // This is no longer required...
                $table->dropIndex('firstname');
            }
        });

        Schema::table('user', function (Blueprint $table) {
            $table->dropIndex('user_email_unique');
        });

        DB::unprepared("ALTER TABLE `user` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");

        // Convert the email field back to UTF8.
        DB::unprepared("ALTER TABLE `user` CHANGE `email` `email` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL;");

        Schema::table('user', function (Blueprint $table) {
            $table->unique('email');
        });

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        (new UpdateLanguageTable)->down();

        // Change firstname, lastname, email to utf8
        DB::unprepared("ALTER TABLE `user` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci");

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
