<?php
/**
 * File 2016_09_12_171901_update_mass_email_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\User;

use App\Modules\Core\Models\Brand;
use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateMassEmailTable
 *
 * @package    Database\Migrations\v2_1_0\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateMassEmailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('mass_email', function (Blueprint $table) {
            $table->integer('brand_id')->unsigned()->after('id');
        });

        // Only if we have existing records (not on fresh install)
        if (DB::table('mass_email')->count()) {
            DB::table('mass_email')->update([ 'brand_id' => Brand::first()->id ]);
        }

        Schema::table('mass_email', function (Blueprint $table) {
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('mass_email', function (Blueprint $table) {
            $table->dropForeign([ 'brand_id' ]);
            $table->dropColumn('brand_id');
        });
    }
}
