<?php
/**
 * File 2016_11_04_108340_update_user_table.php
 *
 * @package    Database\Migrations\v2_1_0\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\User;

use App\Modules\Core\Models\Brand;
use App\Modules\User\Models\User;
use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateUserTable
 *
 * @package    Database\Migrations\v2_1_0\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateUserTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add brand column.
        Schema::table('user', function (Blueprint $table) {
            $table->integer('brand_id')->unsigned()->nullable()->after('id');
        });

        // Only if we have existing users (not on fresh install)
        if (DB::table('user')->count()) {
            // Don't include operators
            $operators = User::operator()->pluck('id');
            DB::table('user')->whereNotIn('id', $operators)->update([ 'brand_id' => Brand::first()->id ]);
        }

        Schema::table('user', function (Blueprint $table) {
            // Add foreign key for brand
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');

            // Add unique combination for brand and user email.
            $table->dropUnique('user_email_unique');
            $table->unique([ 'brand_id', 'email' ]);

            // DEV-1089.
            $table->string('password', 510)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user', function (Blueprint $table) {
            // Remove unique and foreign key
            $table->dropForeign([ 'brand_id' ]);
            $table->dropUnique([ 'brand_id', 'email' ]);

            // Add back email unique index.
            $table->unique('email');

            // Drop brand column
            $table->dropColumn('brand_id');

            // DEV-1089.
            $table->string('password', 255)->change();
        });
    }
}
