<?php
/**
 * File 2016_11_07_115200_update_user_organisation_table.php
 *
 * @package    Database\Migrations\v2_1_0\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\User;

use App\Modules\Core\Models\Brand;
use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateUserOrganisationTable
 *
 * @package    Database\Migrations\v2_1_0\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateUserOrganisationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add brand column
        Schema::table('user_organisation', function (Blueprint $table) {
            $table->integer('brand_id')->unsigned()->after('id');
        });

        // Only if we have existing organisations (not on fresh install)
        if (DB::table('user_organisation')->count()) {
            DB::table('user_organisation')->update([ 'brand_id' => Brand::first()->id ]);
        }

        // Add foreign key for brand
        Schema::table('user_organisation', function (Blueprint $table) {
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_organisation', function (Blueprint $table) {
            // Remove foreign key and drop column
            $table->dropForeign([ 'brand_id' ]);
            $table->dropColumn('brand_id');
        });
    }
}
