<?php
/**
 * File 2016_09_16_155700_update_operator_setting_table.php
 *
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Migrations\v2_1_0\User;

use App\Modules\User\Models\OperatorSetting;
use DB;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateOperatingSettingTable
 *
 * @package    Database\Migrations\v2_1_0\User
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class UpdateOperatingSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $time = time();

        // Copy ticket signatures to operator_signature table
        $signatures = OperatorSetting::all([ 'user_id', 'ticket_signature' ]);

        foreach ($signatures as $signature) {
            if (! empty($signature->ticket_signature)) {
                DB::table('operator_signature')->insert([
                    'user_id'    => $signature->user_id,
                    'contents'   => $signature->ticket_signature,
                    'created_at' => $time,
                    'updated_at' => $time
                ]);
            }
        }

        Schema::table('operator_setting', function (Blueprint $table) {
            // Remove new column
            $table->dropColumn('ticket_signature');

            // Add column
            $table->tinyInteger('default_ticket_filter')
                ->default(0)
                ->after('ticket_reply_order');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            // Add back column
            $table->longText('ticket_signature')
                ->after('template');

            // Remove new column
            $table->dropColumn('default_ticket_filter');
        });
    }
}
