<?php
/**
 * File 2017_02_15_101225_update_email_queue_table.php
 *
 * @package    Database\Migrations\v2_1_2\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.2
 */
namespace Database\Migrations\v2_1_2\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateEmailQueueTable
 *
 * @package    Database\Migrations\v2_1_2\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.2
 */
class UpdateEmailQueueTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('email_queue', function (Blueprint $table) {
            $table->string('reply_to')->nullable()->after('from_email');
            $table->mediumText('to')->nullable()->change();
            $table->mediumText('bcc')->nullable()->after('cc');
            $table->text('log')->nullable()->after('guid');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('email_queue', function (Blueprint $table) {
            $table->dropColumn([ 'reply_to', 'bcc', 'log' ]);
            $table->mediumText('to')->nullable(false)->default(null)->change();
        });
    }
}
