<?php
/**
 * File 2017_02_17_101226_update_email_log_table.php
 *
 * @package    Database\Migrations\v2_1_2\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.2
 */
namespace Database\Migrations\v2_1_2\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateEmailLogTable
 *
 * @package    Database\Migrations\v2_1_2\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.2
 */
class UpdateEmailLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('email_log', function (Blueprint $table) {
            $table->mediumText('reply_to')->nullable()->after('from_user_id');
            $table->mediumText('to')->nullable()->change();
            $table->mediumText('bcc')->nullable()->after('cc');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('email_log', function (Blueprint $table) {
            $table->dropColumn([ 'reply_to', 'bcc' ]);
            $table->mediumText('to')->nullable(false)->default(null)->change();
        });
    }
}
