<?php
/**
 * Update Email Batch Table Migration
 *
 * @package    Database\Migrations\v2_1_2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.2
 */
namespace Database\Migrations\v2_1_2\Core;

use Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateEmailBatchTable
 *
 * @package    Database\Migrations\v2_1_2\Core
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.2
 */
class UpdateEmailBatchTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('email_batch', function (Blueprint $table) {
            $table->tinyInteger('complete')->after('interval')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('email_batch', function (Blueprint $table) {
            $table->dropColumn('complete');
        });
    }
}
