<?php
/**
 * File 2017_02_16_123002_update_department_table.php
 *
 * @package    Database\Migrations\v2_1_2\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.2
 */
namespace Database\Migrations\v2_1_2\Ticket;

use App\Modules\Ticket\Models\Department;
use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateDepartmentTable
 *
 * @package    Database\Migrations\v2_1_2\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.2
 */
class UpdateDepartmentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('department', function (Blueprint $table) {
            $table->string('from_name')->nullable()->after('ticket_number_format');
            $table->tinyInteger('notify_frontend_ticket')->default(1)->after('default_assignedto');
        });

        // DEV-1396: Add attachment rejected email template to each department.
        $defaultTemplates = Department::getEmailTemplates();
        $departments = DB::table('department')->get();
        foreach ($departments as $department) {
            if (isset($department->email_templates)) {
                $templates = json_decode($department->email_templates, true);

                // Add user_ prefix to existing records.
                foreach ($templates as $key => $value) {
                    $templates['user_' . $key] = $value;
                    unset($templates[$key]);
                }

                $templates['user_email_attachmentrejected'] = $defaultTemplates['user_email_attachmentrejected'];
                $templates['user_ticket_disablereplies'] = -1;

                // Add operator email templates.
                $templates = array_merge($templates, Department::getOperatorTemplates());

                DB::table('department')->where('id', $department->id)
                    ->update([ 'email_templates' => json_encode($templates) ]);
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('department', function (Blueprint $table) {
            $table->dropColumn([ 'from_name', 'notify_frontend_ticket' ]);
        });

        // DEV-1396: Add attachment rejected email template to each department.
        $departments = DB::table('department')->get();
        foreach ($departments as $department) {
            if (isset($department->email_templates)) {
                $templates = json_decode($department->email_templates, true);

                foreach ($templates as $key => $value) {
                    $newKey = preg_replace('/^user_/', '', $key);
                    if (! empty($newKey)) {
                        $templates[$newKey] = $value;
                        unset($templates[$key]);
                    }
                }

                unset($templates['user_email_attachmentrejected']);
                unset($templates['user_ticket_disablereplies']);

                // Unset operator email templates.
                $keys = array_keys(Department::getOperatorTemplates());
                foreach ($keys as $name) {
                    unset($templates[$name]);
                }

                DB::table('department')->where('id', $department->id)
                    ->update([ 'email_templates' => json_encode($templates) ]);
            }
        }
    }
}
