<?php
/**
 * File 2017_03_05_189203_update_ticket_table.php
 *
 * @package    Database\Migrations\v2_1_2\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.2
 */
namespace Database\Migrations\v2_1_2\Ticket;

use App\Modules\Ticket\Models\Status;
use Config;
use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketTable
 *
 * @package    Database\Migrations\v2_1_2\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.2
 */
class UpdateTicketTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add new columns
        Schema::table('ticket', function (Blueprint $table) {
            $table->integer('messages_count')->nullable()->after('response_email_sent')->default(null);
            $table->integer('notes_count')->nullable()->after('messages_count')->default(null);
            $table->tinyInteger('has_attachments')->nullable()->after('notes_count')->default(null);
            $table->tinyInteger('has_draft')->after('has_attachments')->default(0);

            $table->integer('last_reply_id')->unsigned()->nullable()->after('last_reply_time')->default(null);
            $table->foreign('last_reply_id')->references('id')->on('ticket_message')->onDelete('set null');

            $table->integer('last_message_id')->unsigned()->nullable()->after('last_reply_id')->default(null);
            $table->foreign('last_message_id')->references('id')->on('ticket_message')->onDelete('set null');
        });

        // If any tickets have a due time of 0, set them to null.
        DB::table('ticket')->where('due_time', 0)->update([ 'due_time' => null ]);

        // Get open tickets (with a status that should auto close) which have at least one operator reply and set the
        // last message ID for each.
        $statuses = Status::where('auto_close', 1)
            ->where('id', '!=', Config::get('settings.default_resolved_status', 0))
            ->pluck('id');
        if (! $statuses->isEmpty()) {
            DB::update(
                "UPDATE `ticket` t
                    JOIN `ticket_message` m1
                        ON t.`id` = m1.`ticket_id` AND m1.`type` = 0 AND m1.`is_draft` = 0
                    LEFT OUTER JOIN `ticket_message` m2
                        ON t.id = m2.ticket_id AND m1.id < m2.id AND m2.type = 0 AND m2.`is_draft` = 0
                    SET t.`last_message_id` = m1.`id`
                        WHERE m2.id IS NULL AND t.status_id IN (" . $statuses->implode(', ') . ")"
            );
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Remove columns
        Schema::table('ticket', function (Blueprint $table) {
            $table->dropForeign([ 'last_reply_id' ]);
            $table->dropForeign([ 'last_message_id' ]);
            $table->dropColumn([
                'messages_count', 'notes_count', 'has_attachments', 'has_draft', 'last_reply_id', 'last_message_id'
            ]);
        });
    }
}
