<?php
/**
 * File 2017_06_12_180300_update_plugin_table.php
 *
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdatePluginTable
 *
 * @package    Database\Migrations\v2_2_0\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdatePluginTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('plugin', function (Blueprint $table) {
            $table->string('version')->nullable()->after('enabled');
            $table->tinyInteger('upgrade_available')->default(0)->after('enabled');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('plugin', function (Blueprint $table) {
            $table->dropColumn('version');
            $table->dropColumn('upgrade_available');
        });
    }
}
