<?php
/**
 * File 2017_06_14_133000_update_brand_operator_group_membership_table.php
 *
 * @package    Database\Migrations\v2_2_0\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateBrandOperatorGroupMembershipTable
 *
 * @package    Database\Migrations\v2_2_0\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateBrandOperatorGroupMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop foreign keys.
        Schema::table('brand_operator_group_membership', function (Blueprint $table) {
            $table->dropForeign([ 'brand_id' ]);
            $table->dropForeign([ 'group_id' ]);
        });

        // Remove NULLABLE.
        Schema::table('brand_operator_group_membership', function (Blueprint $table) {
            $table->integer('brand_id')->unsigned()->nullable(false)->default(null)->change();
            $table->integer('group_id')->unsigned()->nullable(false)->default(null)->change();
        });

        // Add foreign keys back.
        Schema::table('brand_operator_group_membership', function (Blueprint $table) {
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');
            $table->foreign('group_id')->references('id')->on('user_group')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop foreign keys.
        Schema::table('brand_operator_group_membership', function (Blueprint $table) {
            $table->dropForeign([ 'brand_id' ]);
            $table->dropForeign([ 'group_id' ]);
        });

        Schema::table('brand_operator_group_membership', function (Blueprint $table) {
            $table->integer('brand_id')->unsigned()->nullable()->change();
            $table->integer('group_id')->unsigned()->nullable()->change();
        });

        // Add foreign keys back.
        Schema::table('brand_operator_group_membership', function (Blueprint $table) {
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');
            $table->foreign('group_id')->references('id')->on('user_group')->onDelete('cascade');
        });
    }
}
