<?php
/**
 * File 2017_06_15_134209_update_email_queue_attachments_table.php
 *
 * @package    Database\Migrations\v2_2_0\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Core;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateEmailQueueAttachmentsTable
 *
 * @package    Database\Migrations\v2_2_0\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateEmailQueueAttachmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('email_queue_attachments', 'queue_id', 'upload_id');
        
        Schema::table('email_queue_attachments', function (Blueprint $table) {
            $table->unique([ 'queue_id', 'upload_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('email_queue_attachments', function (Blueprint $table) {
            $table->dropForeign([ 'queue_id' ]);
            $table->dropForeign([ 'upload_id' ]);
        });
        
        Schema::table('email_queue_attachments', function (Blueprint $table) {
            $table->dropUnique([ 'queue_id', 'upload_id' ]);
        });
        
        Schema::table('email_queue_attachments', function (Blueprint $table) {
            $table->foreign('queue_id')->references('id')->on('email_queue')->onDelete('cascade');
            $table->foreign('upload_id')->references('id')->on('upload')->onDelete('cascade');
        });
    }
}
