<?php
/**
 * File 2017_08_08_134353_update_scheduled_task_table.php
 *
 * @package    Database\Migrations\v2_2_0\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Core;

use DB;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateScheduledTaskTable
 *
 * @package    Database\Migrations\v2_2_0\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateScheduledTaskTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::table('scheduled_task')
            ->where('class', 'App\Modules\Ticket\Models\Ticket')
            ->update([ 'interval' => '585' ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::table('scheduled_task')
            ->where('class', 'App\Modules\Ticket\Models\Ticket')
            ->update([ 'interval' => '3585' ]);
    }
}
