<?php
/**
 * File 2017_06_14_132400_update_article_tag_membership_table.php
 *
 * @package    Database\Migrations\v2_2_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Selfservice;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateArticleTagMembershipTable
 *
 * @package    Database\Migrations\v2_2_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateArticleTagMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('article_tag_membership', 'article_id', 'tag_id');
        
        Schema::table('article_tag_membership', function (Blueprint $table) {
            $table->unique([ 'article_id', 'tag_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop foreign keys.
        Schema::table('article_tag_membership', function (Blueprint $table) {
            $table->dropForeign([ 'article_id' ]);
            $table->dropForeign([ 'tag_id' ]);
        });
        
        // Drop unique index.
        Schema::table('article_tag_membership', function (Blueprint $table) {
            $table->dropUnique([ 'article_id', 'tag_id' ]);
        });
        
        // Add foreign keys back.
        Schema::table('article_tag_membership', function (Blueprint $table) {
            $table->foreign('article_id')->references('id')->on('article')->onDelete('cascade');
            $table->foreign('tag_id')->references('id')->on('article_tag')->onDelete('cascade');
        });
    }
}
