<?php
/**
 * File 2017_07_04_111158_create_aritcle_tag_translation_table.php
 *
 * @package    Database\Migrations\v2_2_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Selfservice;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class CreateArticleTagTranslationTable
 *
 * @package    Database\Migrations\v2_2_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class CreateArticleTagTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('article_tag_translation', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('tag_id')->unsigned();
            $table->foreign('tag_id')->references('id')->on('article_tag')->onDelete('cascade');

            $table->string('name', 45);
            $table->text('slug');

            $table->string('locale', 5);
            $table->foreign('locale')->references('code')->on('language')->onDelete('cascade');

            $table->unique([ 'tag_id', 'locale' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('article_tag_translation');
    }
}
