<?php
/**
 * File 2017_07_05_143206_create_article_translation_table.php
 *
 * @package    Database\Migrations\v2_2_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Selfservice;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class CreateArticleTranslationTable
 *
 * @package    Database\Migrations\v2_2_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class CreateArticleTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('article_translation', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('article_id')->unsigned();
            $table->foreign('article_id')->references('id')->on('article')->onDelete('cascade');

            $table->string('title');
            $table->text('slug');
            $table->string('keywords')->nullable();
            $table->longText('excerpt')->nullable();
            $table->longText('text');

            $table->string('locale', 5);
            $table->foreign('locale')->references('code')->on('language')->onDelete('cascade');

            $table->unique([ 'article_id', 'locale' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('article_translation');
    }
}
