<?php
/**
 * File 2017_07_28_180800_update_comment_table.php
 *
 * @package    Database\Migrations\v2_2_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Selfservice;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateCommentTable
 *
 * @package    Database\Migrations\v2_2_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateCommentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('comment', function (Blueprint $table) {
            $table->mediumText('purified_text')->after('text');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Remove columns
        Schema::table('comment', function (Blueprint $table) {
            $table->dropColumn('purified_text');
        });
    }
}