<?php
/**
 * File 2017_08_03_095030_update_article_table.php
 *
 * @package    Database\Migrations\v2_2_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Selfservice;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateArticleTable
 *
 * @package    Database\Migrations\v2_2_0\Selfservice
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateArticleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop foreign key constraint.
        Schema::table('article', function (Blueprint $table) {
            $table->dropForeign('article_author_id_foreign');
        });
        
        // Add constraint back.
        Schema::table('article', function (Blueprint $table) {
            $table->integer('author_id')->unsigned()->nullable()->change();
            $table->foreign('author_id')->references('id')->on('user')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop foreign key constraint.
        Schema::table('article', function (Blueprint $table) {
            $table->dropForeign('article_author_id_foreign');
        });

        // Add constraint back.
        Schema::table('article', function (Blueprint $table) {
            $table->integer('author_id')->unsigned()->nullable(false)->default(null)->change();
            $table->foreign('author_id')->references('id')->on('user')->onDelete('cascade');
        });
    }
}
