<?php
/**
 * File 2017_04_12_189203_update_ticket_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateTicketTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket', function (Blueprint $table) {
            $table->integer('reopened_time')->nullable()->after('resolved_time');
            $table->integer('last_message_time')->after('last_reply_time')->default(0);
            $table->tinyInteger('last_reply_by')->nullable()->after('last_message_id');
            $table->tinyInteger('last_message_by')->nullable()->after('last_reply_by');

            $table->index([ 'last_reply_by' ]);
            $table->index([ 'last_message_by' ]);
            $table->index([ 'department_id', 'brand_id', 'status_id' ]);
            $table->index([ 'due_time' ]);
            $table->index([ 'last_reply_time' ]);
            $table->index([ 'created_at' ]);
        });

        // Set the last message time to be the same as the last reply time initially.
        DB::table('ticket')->update([ 'last_message_time' => DB::raw("`last_reply_time`") ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Remove columns
        Schema::table('ticket', function (Blueprint $table) {
            // We need to drop the foreign keys in order to drop the indexes associated with them.
            $table->dropForeign([ 'department_id' ]);
            $table->dropForeign([ 'brand_id' ]);
            $table->dropForeign([ 'status_id' ]);

            $table->dropIndex([ 'last_reply_by' ]);
            $table->dropIndex([ 'last_message_by' ]);
            $table->dropIndex([ 'department_id', 'brand_id', 'status_id' ]);
            $table->dropIndex([ 'due_time' ]);
            $table->dropIndex([ 'last_reply_time' ]);
            $table->dropIndex([ 'created_at' ]);

            // Recreate the foreign keys.
            $table->foreign('department_id')->references('id')->on('department')->onDelete('cascade');
            $table->foreign('brand_id')->references('id')->on('brand')->onDelete('cascade');
            $table->foreign('status_id')->references('id')->on('ticket_status')->onDelete('cascade');

            $table->dropColumn([ 'reopened_time', 'last_message_time', 'last_reply_by', 'last_message_by' ]);
        });
    }
}
