<?php
/**
 * File 2017_05_29_189205_create_ticket_status_translation_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class CreateTicketStatusTranslationTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class CreateTicketStatusTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create translation table.
        Schema::create('ticket_status_translation', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
            
            $table->integer('status_id')->unsigned();
            $table->foreign('status_id')->references('id')->on('ticket_status')->onDelete('cascade');

            $table->string('name', 45);

            $table->string('locale', 5);
            $table->foreign('locale')->references('code')->on('language')->onDelete('cascade');

            $table->unique([ 'status_id', 'locale' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop translation table.
        Schema::drop('ticket_status_translation');
    }
}
