<?php
/**
 * File 2017_06_12_189209_create_ticket_customfield_option_translation_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class CreateTicketCustomFieldOptionTranslationTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class CreateTicketCustomFieldOptionTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create translation table.
        Schema::create('ticket_customfield_option_translation', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
            
            $table->integer('ticket_custom_field_option_id')->unsigned();
            $table->foreign('ticket_custom_field_option_id', 'ticket_cf_option_id_fk')
                ->references('id')
                ->on('ticket_customfield_option')
                ->onDelete('cascade');

            $table->string('value');
            
            $table->string('locale', 5);
            $table->foreign('locale')->references('code')->on('language')->onDelete('cascade');

            $table->unique([ 'ticket_custom_field_option_id', 'locale' ], 'ticket_cf_option_id_locale_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop translation table.
        Schema::drop('ticket_customfield_option_translation');
    }
}
