<?php
/**
 * File 2017_06_12_189212_create_feedback_form_field_option_translation_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class CreateFeedbackFormFieldOptionTranslationTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class CreateFeedbackFormFieldOptionTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create translation table.
        Schema::create('feedback_form_field_option_translation', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
            
            $table->integer('feedback_form_field_option_id')->unsigned();
            $table->foreign('feedback_form_field_option_id', 'feedback_form_field_option_id_fk')
                ->references('id')
                ->on('feedback_form_field_option')
                ->onDelete('cascade');

            $table->string('value');

            $table->string('locale', 5);
            $table->foreign('locale')->references('code')->on('language')->onDelete('cascade');

            $table->unique(
                [ 'feedback_form_field_option_id', 'locale' ],
                'feedback_form_field_option_id_locale_unique'
            );
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop translation table.
        Schema::drop('feedback_form_field_option_translation');
    }
}
