<?php
/**
 * File 2017_06_15_133229_update_canned_response_group_membership_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateCannedResponseGroupMembershipTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateCannedResponseGroupMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('canned_response_group_membership', 'response_id', 'group_id');
        
        Schema::table('canned_response_group_membership', function (Blueprint $table) {
            $table->unique([ 'response_id', 'group_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop foreign keys
        Schema::table('canned_response_group_membership', function (Blueprint $table) {
            $table->dropForeign([ 'response_id' ]);
            $table->dropForeign([ 'group_id' ]);
        });
        
        // Drop unique constraint.
        Schema::table('canned_response_group_membership', function (Blueprint $table) {
            $table->dropUnique([ 'response_id', 'group_id' ]);
        });

        // Add foreign keys
        Schema::table('canned_response_group_membership', function (Blueprint $table) {
            $table->foreign('response_id')->references('id')->on('canned_response')->onDelete('cascade');
            $table->foreign('group_id')->references('id')->on('user_group')->onDelete('cascade');
        });
    }
}
