<?php
/**
 * File 2017_06_15_133935_update_department_priority_membership_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateDepartmentPriorityMembershipTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateDepartmentPriorityMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('department_priority_membership', 'department_id', 'priority_id');
        
        Schema::table('department_priority_membership', function (Blueprint $table) {
            $table->unique([ 'department_id', 'priority_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('department_priority_membership', function (Blueprint $table) {
            $table->dropForeign([ 'department_id' ]);
            $table->dropForeign([ 'priority_id' ]);
        });
        
        Schema::table('department_priority_membership', function (Blueprint $table) {
            $table->dropUnique([ 'department_id', 'priority_id' ]);
        });

        Schema::table('department_priority_membership', function (Blueprint $table) {
            $table->foreign('department_id')->references('id')->on('department')->onDelete('cascade');
            $table->foreign('priority_id')->references('id')->on('ticket_priority')->onDelete('cascade');
        });
    }
}
