<?php
/**
 * File 2017_06_15_135309_update_ticket_filter_group_membership_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketFilterGroupMembershipTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateTicketFilterGroupMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('ticket_filter_group_membership', 'filter_id', 'group_id');
        
        Schema::table('ticket_filter_group_membership', function (Blueprint $table) {
            $table->unique([ 'filter_id', 'group_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_filter_group_membership', function (Blueprint $table) {
            $table->dropForeign([ 'filter_id' ]);
            $table->dropForeign([ 'group_id' ]);
        });

        Schema::table('ticket_filter_group_membership', function (Blueprint $table) {
            $table->dropUnique([ 'filter_id', 'group_id' ]);
        });
        
        Schema::table('ticket_filter_group_membership', function (Blueprint $table) {
            $table->foreign('filter_id')->references('id')->on('ticket_filter')->onDelete('cascade');
            $table->foreign('group_id')->references('id')->on('user_group')->onDelete('cascade');
        });
    }
}
