<?php
/**
 * File 2017_06_15_135326_update_ticket_filter_viewed_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketFilterViewedTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateTicketFilterViewedTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop foreign keys.
        Schema::table('ticket_filter_viewed', function (Blueprint $table) {
            $table->dropForeign([ 'filter_id' ]);
            $table->dropForeign([ 'user_id' ]);
        });

        // Remove NULLABLE.
        Schema::table('ticket_filter_viewed', function (Blueprint $table) {
            $table->integer('filter_id')->unsigned()->nullable(false)->default(null)->change();
            $table->integer('user_id')->unsigned()->nullable(false)->default(null)->change();
        });

        // Add foreign keys back.
        Schema::table('ticket_filter_viewed', function (Blueprint $table) {
            $table->foreign('filter_id')->references('id')->on('ticket_filter')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_filter_viewed', function (Blueprint $table) {
            $table->dropForeign([ 'filter_id' ]);
            $table->dropForeign([ 'user_id' ]);
        });

        Schema::table('ticket_filter_viewed', function (Blueprint $table) {
            $table->integer('filter_id')->unsigned()->nullable()->change();
            $table->integer('user_id')->unsigned()->nullable()->change();
        });
        
        Schema::table('ticket_filter_viewed', function (Blueprint $table) {
            $table->foreign('filter_id')->references('id')->on('ticket_filter')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');
        });
    }
}
