<?php
/**
 * File 2017_06_15_135342_update_ticket_tag_membership_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketTagMembershipTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateTicketTagMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('ticket_tag_membership', 'ticket_id', 'tag_id');

        Schema::table('ticket_tag_membership', function (Blueprint $table) {
            $table->unique([ 'ticket_id', 'tag_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_tag_membership', function (Blueprint $table) {
            $table->dropForeign([ 'ticket_id' ]);
            $table->dropForeign([ 'tag_id' ]);
        });

        Schema::table('ticket_tag_membership', function (Blueprint $table) {
            $table->dropUnique([ 'ticket_id', 'tag_id' ]);
        });

        Schema::table('ticket_tag_membership', function (Blueprint $table) {
            $table->foreign('ticket_id')->references('id')->on('ticket')->onDelete('cascade');
            $table->foreign('tag_id')->references('id')->on('ticket_tag')->onDelete('cascade');
        });
    }
}
