<?php
/**
 * File 2017_06_15_135357_update_ticket_viewed_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateTicketViewedTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateTicketViewedTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('ticket_viewed', 'ticket_id', 'user_id');
        
        Schema::table('ticket_viewed', function (Blueprint $table) {
            $table->unique([ 'ticket_id', 'user_id' ]);
            $table->index([ 'user_type', 'updated_at' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_viewed', function (Blueprint $table) {
            $table->dropForeign([ 'ticket_id' ]);
            $table->dropForeign([ 'user_id' ]);
        });

        Schema::table('ticket_viewed', function (Blueprint $table) {
            $table->dropUnique([ 'ticket_id', 'user_id' ]);
            $table->dropIndex([ 'user_type', 'updated_at' ]);
        });
        
        Schema::table('ticket_viewed', function (Blueprint $table) {
            $table->foreign('ticket_id')->references('id')->on('ticket')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');
        });
    }
}
