<?php
/**
 * File 2017_06_15_141923_update_department_customfield_membership_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdateDepartmentCustomfieldMembershipTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateDepartmentCustomfieldMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('department_customfield_membership', 'field_id', 'department_id');
        
        Schema::table('department_customfield_membership', function (Blueprint $table) {
            $table->unique([ 'field_id', 'department_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('department_customfield_membership', function (Blueprint $table) {
            $table->dropForeign([ 'field_id' ]);
            $table->dropForeign([ 'department_id' ]);
        });

        Schema::table('department_customfield_membership', function (Blueprint $table) {
            $table->dropUnique([ 'field_id', 'department_id' ]);
        });
        
        Schema::table('department_customfield_membership', function (Blueprint $table) {
            $table->foreign('field_id')->references('id')->on('ticket_customfield')->onDelete('cascade');
            $table->foreign('department_id')->references('id')->on('department')->onDelete('cascade');
        });
    }
}
