<?php
/**
 * File 2017_07_03_130600_update_merge_log_table.php
 *
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateMergeLogTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateMergeLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('merge_log', function (Blueprint $table) {
            $table->text('extra')->nullable()->after('tags');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('merge_log', function (Blueprint $table) {
            $table->dropColumn('extra');
        });
    }
}
