<?php
/**76
 * File 2017_08_01_144700_update_ticket_filter_condition_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use App\Modules\Ticket\Models\Condition;
use DB;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateTicketFilterConditionTable
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateTicketFilterConditionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Update all ticket message content conditions to use contains
        DB::table('ticket_filter_condition')
            ->where('item', Condition::TICKET_MESSAGE_CONTENT)
            ->update([ 'operator' => 3 ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Do nothing
    }
}
