<?php
/**
 * File 2017_09_01_189203_update_ticket_table.php
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\Ticket;

use Config;
use DB;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateResolvedStatus
 *
 * @package    Database\Migrations\v2_2_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateResolvedStatus extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Set the resolved time to null on unresolved tickets.
        if ($resolvedStatusId = Config::get('settings.default_resolved_status', 0)) {
            DB::table('ticket')->where('status_id', '!=', $resolvedStatusId)
                ->update([ 'resolved_time' => null ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
