<?php
/**
 * File 2017_05_05_115800_update_permission_table.php
 *
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\User;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdatePermissionTable
 *
 * @package    Database\Migrations\v2_2_0\User
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdatePermissionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('permission', function (Blueprint $table) {
            $table->integer('module_id')->unsigned()->nullable()->change();

            $table->integer('plugin_id')->unsigned()->nullable()->after('module_id');
            $table->foreign('plugin_id')->references('id')->on('plugin')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('permission', function (Blueprint $table) {
            $table->integer('module_id')->unsigned()->change();

            $table->dropForeign([ 'plugin_id' ]);
            $table->dropColumn('plugin_id');
        });
    }
}
