<?php
/**
 * File 2017_06_14_189210_create_role_translation_table.php
 *
 * @package    Database\Migrations\v2_2_0\User
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\User;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class CreateRoleTranslationTable
 *
 * @package    Database\Migrations\v2_2_0\User
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class CreateRoleTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Create translation table.
        Schema::create('role_translation', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('role_id')->unsigned();
            $table->foreign('role_id')->references('id')->on('role')->onDelete('cascade');

            $table->string('name');
            $table->mediumText('description')->nullable();

            $table->string('locale', 5);
            $table->foreign('locale')->references('code')->on('language')->onDelete('cascade');

            $table->unique([ 'role_id', 'locale' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop translation table.
        Schema::drop('role_translation');
    }
}
