<?php
/**
 * File 2017_06_15_135251_update_permission_role_table.php
 *
 * @package    Database\Migrations\v2_2_0\User
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\User;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

/**
 * Class UpdatePermissionRoleTable
 *
 * @package    Database\Migrations\v2_2_0\User
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdatePermissionRoleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->deleteDuplicates('permission_role', 'permission_id', 'role_id');
        
        Schema::table('permission_role', function (Blueprint $table) {
            $table->unique([ 'permission_id', 'role_id' ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('permission_role', function (Blueprint $table) {
            $table->dropForeign([ 'permission_id' ]);
            $table->dropForeign([ 'role_id' ]);
        });

        Schema::table('permission_role', function (Blueprint $table) {
            $table->dropUnique([ 'permission_id', 'role_id' ]);
        });

        Schema::table('permission_role', function (Blueprint $table) {
            $table->foreign('permission_id')->references('id')->on('permission')->onDelete('cascade');
            $table->foreign('role_id')->references('id')->on('role')->onDelete('cascade');
        });
    }
}
