<?php
/**
 * File 2017_06_15_135430_update_user_viewed_table.php
 *
 * @package    Database\Migrations\v2_2_0\User
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.2.0
 */
namespace Database\Migrations\v2_2_0\User;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateUserViewedTable
 *
 * @package    Database\Migrations\v2_2_0\User
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.0
 */
class UpdateUserViewedTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop foreign keys.
        Schema::table('user_viewed', function (Blueprint $table) {
            $table->dropForeign([ 'user_id' ]);
            $table->dropForeign([ 'operator_id' ]);
        });

        // Remove NULLABLE.
        Schema::table('user_viewed', function (Blueprint $table) {
            $table->integer('user_id')->unsigned()->nullable(false)->default(null)->change();
            $table->integer('operator_id')->unsigned()->nullable(false)->default(null)->change();
        });

        // Add foreign keys back.
        Schema::table('user_viewed', function (Blueprint $table) {
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');
            $table->foreign('operator_id')->references('id')->on('user')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_viewed', function (Blueprint $table) {
            $table->dropForeign([ 'user_id' ]);
            $table->dropForeign([ 'operator_id' ]);
        });

        Schema::table('user_viewed', function (Blueprint $table) {
            $table->integer('user_id')->unsigned()->nullable()->change();
            $table->integer('operator_id')->unsigned()->nullable()->change();
        });
        
        Schema::table('user_viewed', function (Blueprint $table) {
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');
            $table->foreign('operator_id')->references('id')->on('user')->onDelete('cascade');
        });
    }
}
