<?php
/**
 * File 2017_12_22_151732_update_operator_private_conversation_table.php
 *
 * @package    Database\Migrations\v2_3_0\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Migrations\v2_3_0\Core;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateOperatorPrivateConversationTable
 *
 * @package    Database\Migrations\v2_3_0\Core
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.2.1
 */
class UpdateOperatorPrivateConversationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('operator_private_conversation', function (Blueprint $table) {
            $table->unique([ 'from_user_id', 'to_user_id' ], 'operator_private_conversation_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('operator_private_conversation', function (Blueprint $table) {
            // Need to drop foreign index first
            $table->dropForeign([ 'from_user_id' ]);
            $table->dropForeign([ 'to_user_id' ]);

            // Remove unique index
            $table->dropUnique('operator_private_conversation_unique');

            // Add foreign index back
            $table->foreign('from_user_id')->references('id')->on('user')->onDelete('cascade');
            $table->foreign('to_user_id')->references('id')->on('user')->onDelete('cascade');
        });
    }
}
