<?php
/**
 * File 2017_09_21_189203_update_department_table.php
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Migrations\v2_3_0\Ticket;

use App\Modules\Ticket\Models\Department;
use DB;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateDepartmentTable
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class UpdateDepartmentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add user_ticket_registeredonly template.
        $defaultTemplates = Department::getEmailTemplates();
        $departments = DB::table('department')->get();
        foreach ($departments as $department) {
            if (isset($department->email_templates)) {
                $templates = json_decode($department->email_templates, true);

                $templates['user_ticket_registeredonly'] = $defaultTemplates['user_ticket_registeredonly'];
                $templates['user_user_ticket_reply'] = $defaultTemplates['user_user_ticket_reply'];

                DB::table('department')->where('id', $department->id)
                    ->update([ 'email_templates' => json_encode($templates) ]);
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Remove user_ticket_registeredonly template.
        $departments = DB::table('department')->get();
        foreach ($departments as $department) {
            if (isset($department->email_templates)) {
                $templates = json_decode($department->email_templates, true);

                unset($templates['user_ticket_registeredonly']);
                unset($templates['user_user_ticket_reply']);

                DB::table('department')->where('id', $department->id)
                    ->update([ 'email_templates' => json_encode($templates) ]);
            }
        }
    }
}
