<?php
/**
 * File 2017_10_02_081825_update_ticket_customfield_table.php
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Migrations\v2_3_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketCustomfieldTable
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class UpdateTicketCustomfieldTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_customfield', function (Blueprint $table) {
            $table->text('regex')->nullable()->after('locked');
            $table->text('regex_error_message')->nullable()->after('regex');

            $table->integer('depends_on_field_id')->unsigned()->nullable()->after('type');
            $table->foreign('depends_on_field_id')->references('id')->on('ticket_customfield')->onDelete('set null');

            $table->integer('depends_on_option_id')->unsigned()->nullable()->after('depends_on_field_id');
            $table->foreign('depends_on_option_id')->references('id')->on('ticket_customfield_option')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_customfield', function (Blueprint $table) {
            $table->dropColumn('regex', 'regex_error_message');

            $table->dropForeign([ 'depends_on_field_id' ]);
            $table->dropColumn('depends_on_field_id');
            $table->dropForeign([ 'depends_on_option_id' ]);
            $table->dropColumn('depends_on_option_id');
        });
    }
}
