<?php
/**
 * File 2017_10_02_083054_update_ticket_customfield_translation_table.php
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Migrations\v2_3_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketCustomfieldTranslationTable
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class UpdateTicketCustomfieldTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_customfield_translation', function (Blueprint $table) {
            $table->text('regex_error_message')->nullable()->after('description');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_customfield_translation', function (Blueprint $table) {
            $table->dropColumn('regex_error_message');
        });
    }
}
