<?php
/**
 * File 2017_10_11_123655_update_ticket_macro_action_table.php
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.3.0
 */
namespace Database\Migrations\v2_3_0\Ticket;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Schema;

/**
 * Class UpdateTicketMacroActionTable
 *
 * @package    Database\Migrations\v2_3_0\Ticket
 * @copyright  Copyright (c) 2015-2017 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.3.0
 */
class UpdateTicketMacroActionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_macro_action', function (Blueprint $table) {
            $table->integer('order')->unsigned()->nullable()->after('macro_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_macro_action', function (Blueprint $table) {
            $table->dropColumn('order');
        });
    }
}
